import matplotlib.pyplot as plt

# Coordinates of the cities
cities = {
    0: (91, 59),
    1: (70, 43),
    2: (7, 46),
    3: (34, 77),
    4: (80, 35),
    5: (49, 3),
    6: (1, 5),
    7: (53, 3),
    8: (53, 92),
    9: (62, 17)
}

# Solution path
solution = [0, 4, 5, 1]

# Extracting coordinates for the solution path
solution_coords = [cities[city] for city in solution + [0]]  # Adding city 0 at the end to complete the loop

# Plotting
plt.figure(figsize=(10, 8))
plt.plot(*zip(*solution_coords), marker='o', color='b', linestyle='-')
plt.title('TSP Solution Visualization')
plt.xlabel('X Coordinate')
plt.ylabel('Y Coordinate')

# Annotating city numbers
for city, coord in cities.items():
    plt.annotate(str(city), (coord[0], coord[1]), textcoords="offset points", xytext=(0,10), ha='center')

plt.grid(True)
plt.show()
